# BioVibe - Auto-Posting Biography Platform

A full-stack PHP application designed for Namecheap shared hosting that automatically fetches trending topics, scrapes news, rewrites content using AI, and publishes biographies/obituaries.

## Features

- **Automated Content**: Fetches from Google Trends & RSS.
- **AI Rewriting**: Integrates with OpenAI (or compatible) API to rewrite content.
- **SEO Optimized**: Auto-generates slugs, meta tags, and submits to Google Indexing API.
- **Admin Dashboard**: Manage posts, view stats, and logs.
- **Modern UI**: Dark-mode "Vibe Code" aesthetic using vanilla CSS.
- **Zero Dependencies**: No Node.js, Composer, or build steps required for deployment.

## Deployment Instructions (Namecheap / cPanel)

### 1. File Upload
1.  Zip the contents of this folder (excluding `logs/` and `.git`).
2.  Upload to your `public_html` folder (or a subdirectory) via cPanel File Manager or FTP.
3.  Extract the files.

### 2. Database Setup
1.  Go to **cPanel > MySQL Database Wizard**.
2.  Create a new database (e.g., `username_biovibe`).
3.  Create a new user and password.
4.  Assign the user to the database with **ALL PRIVILEGES**.
5.  Go to **cPanel > phpMyAdmin**.
6.  Select your new database.
7.  Click **Import** and upload the `sql/schema.sql` file.

### 3. Configuration
1.  Rename `.env.example` to `.env`.
2.  Edit `.env` with your details:
    -   `DB_NAME`, `DB_USER`, `DB_PASS`
    -   `AI_API_KEY` (OpenAI Key)
    -   `APP_URL` (e.g., `https://yourdomain.com`)

### 4. Google Indexing (Optional but Recommended)
1.  Create a Service Account in Google Cloud Console.
2.  Enable the "Indexing API".
3.  Download the JSON key file.
4.  Upload it to the root folder (outside `public` if possible) and update `GOOGLE_AUTH_JSON_PATH` in `.env`.

### 5. Cron Job Setup
To automate the posting, set up a Cron Job in cPanel.

1.  Go to **cPanel > Cron Jobs**.
2.  Add a new cron job to run every 10 minutes: `*/10 * * * *`
3.  Command:
    ```bash
    /usr/local/bin/php /home/YOUR_USERNAME/public_html/cron/autopost.php >> /home/YOUR_USERNAME/logs/autopost.log 2>&1
    ```
    *Note: Check cPanel sidebar for the correct PHP path (often `/usr/local/bin/php` or `/opt/cpanel/ea-php81/root/usr/bin/php`).*

### 6. Verify
1.  Visit your site URL.
2.  Log in to `/admin/` with default credentials:
    -   User: `admin`
    -   Pass: `admin123` (Change this immediately!)

## Directory Structure

-   `public/`: Web root (index.php, assets, admin).
-   `cron/`: CLI scripts for automation.
-   `lib/`: Core PHP classes (DB, Scraper, Rewriter).
-   `sql/`: Database schema.
-   `logs/`: Application logs.

## Legal & Ethical Note
This tool scrapes content. Ensure you:
1.  Respect `robots.txt`.
2.  Add significant value via the AI rewrite (do not just copy-paste).
3.  Configure `PLAGIARISM_THRESHOLD` if implementing a checker.
4.  Use the `source_url` to attribute the original source.
