<?php

session_start();

class Auth {
    public static function login($username, $password) {
        $user = DB::fetch("SELECT * FROM users WHERE username = ?", [$username]);
        
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['role'] = $user['role'];
            return true;
        }
        return false;
    }

    public static function logout() {
        session_destroy();
    }

    public static function check() {
        return isset($_SESSION['user_id']);
    }

    public static function requireAdmin() {
        if (!self::check()) {
            header('Location: /admin/login.php');
            exit;
        }
    }
}
