<?php

require_once __DIR__ . '/DB.php';

class Logger {
    public static function log($level, $message, $meta = [], $source = 'SYSTEM') {
        // 1. Write to DB
        try {
            DB::insert('logs', [
                'level' => $level,
                'source' => $source,
                'message' => $message,
                'meta' => json_encode($meta)
            ]);
        } catch (Exception $e) {
            // Fallback if DB fails
            error_log("DB LOG FAILURE: " . $e->getMessage());
        }

        // 2. Write to file
        $logDir = __DIR__ . '/../logs';
        if (!is_dir($logDir)) {
            mkdir($logDir, 0777, true);
        }
        
        $date = date('Y-m-d H:i:s');
        $metaStr = !empty($meta) ? json_encode($meta) : '';
        $line = "[$date] [$level] [$source] $message $metaStr" . PHP_EOL;
        
        file_put_contents($logDir . '/app.log', $line, FILE_APPEND);
    }

    public static function info($message, $meta = [], $source = 'SYSTEM') {
        self::log('INFO', $message, $meta, $source);
    }

    public static function error($message, $meta = [], $source = 'SYSTEM') {
        self::log('ERROR', $message, $meta, $source);
    }
    
    public static function warning($message, $meta = [], $source = 'SYSTEM') {
        self::log('WARNING', $message, $meta, $source);
    }
}
