<?php

require_once __DIR__ . '/Config.php';
require_once __DIR__ . '/Logger.php';

class Rewriter {
    
    public static function rewrite($text, $promptContext = "Rewrite this obituary/biography to be respectful, engaging, and unique. Maintain the key facts but change the wording significantly.") {
        $apiKey = Config::get('AI_API_KEY');
        $model = Config::get('AI_MODEL', 'gpt-3.5-turbo');
        
        if (!$apiKey || $apiKey === 'sk-your-api-key-here') {
            Logger::warning("AI API Key not configured. Returning original text.");
            return $text . " [AI REWRITE DISABLED - CONFIGURE API KEY]";
        }

        $url = 'https://api.openai.com/v1/chat/completions';
        
        $data = [
            'model' => $model,
            'messages' => [
                [
                    'role' => 'system',
                    'content' => 'You are a professional journalist and biographer. ' . $promptContext
                ],
                [
                    'role' => 'user',
                    'content' => substr($text, 0, 4000) // Truncate to avoid token limits
                ]
            ],
            'temperature' => 0.7
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $apiKey
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            Logger::error("AI API Error: $error");
            return $text; // Fallback
        }

        $json = json_decode($response, true);
        
        if (isset($json['error'])) {
            Logger::error("AI API Error Response: " . json_encode($json['error']));
            return $text;
        }

        if (isset($json['choices'][0]['message']['content'])) {
            return $json['choices'][0]['message']['content'];
        }

        return $text;
    }
}
