<?php
require_once __DIR__ . '/../../lib/Config.php';
require_once __DIR__ . '/../../lib/DB.php';
require_once __DIR__ . '/../../lib/Auth.php';
require_once __DIR__ . '/../../lib/Indexer.php';

Config::load(__DIR__ . '/../../.env');
Auth::requireAdmin();

$error = null;
$success = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'] ?? '';
    $content = $_POST['content'] ?? '';
    $status = $_POST['status'] ?? 'draft';
    
    if (!$title || !$content) {
        $error = "Title and Content are required.";
    } else {
        $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $title)));
        // Ensure unique slug
        $slug .= '-' . time();
        
        try {
            $id = DB::insert('posts', [
                'title' => $title,
                'slug' => $slug,
                'content' => $content,
                'source_name' => 'Manual',
                'fingerprint' => md5($title . time()),
                'status' => $status,
                'published_at' => ($status === 'published') ? date('Y-m-d H:i:s') : null
            ]);
            
            if ($status === 'published') {
                // Auto Index
                $url = Config::get('APP_URL') . '/post.php?slug=' . $slug;
                Indexer::requestIndexing($url);
            }
            
            $success = "Post created successfully!";
        } catch (Exception $e) {
            $error = "Error creating post: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New Post - Admin</title>
    <link rel="stylesheet" href="/assets/css/fonts.css">
    <link rel="stylesheet" href="/assets/css/style.css">
    <!-- Quill Editor -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <style>
        /* Quill Dark Mode Overrides */
        .ql-toolbar.ql-snow {
            border-color: var(--border);
            background: var(--bg-card);
        }
        .ql-container.ql-snow {
            border-color: var(--border);
            background: var(--bg-body);
            color: var(--text-main);
            font-family: var(--font-main);
            font-size: 1rem;
        }
        .ql-stroke {
            stroke: var(--text-muted) !important;
        }
        .ql-fill {
            fill: var(--text-muted) !important;
        }
        .ql-picker {
            color: var(--text-muted) !important;
        }
        .ql-editor {
            min-height: 300px;
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <nav>
                <a href="/admin/" class="logo">Admin Panel</a>
                <div class="nav-links">
                    <a href="/admin/">Dashboard</a>
                    <a href="/admin/logout.php">Logout</a>
                </div>
            </nav>
        </div>
    </header>
    
    <main class="container">
        <div class="admin-dashboard">
            <aside class="sidebar">
                <a href="/admin/">Dashboard</a>
                <a href="/admin/add-post.php" class="active">Add New Post</a>
                <a href="/admin/settings.php">Settings</a>
                <a href="/admin/logs.php">Logs</a>
            </aside>
            
            <div class="content">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
                    <h1>Add New Post</h1>
                    <a href="/admin/" class="btn" style="background: var(--bg-card); border: 1px solid var(--border);">Back to Dashboard</a>
                </div>
                
                <?php if ($error): ?>
                    <div style="background: #ef4444; color: white; padding: 1rem; border-radius: 6px; margin-bottom: 1rem;">
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <?php if ($success): ?>
                    <div style="background: #22c55e; color: white; padding: 1rem; border-radius: 6px; margin-bottom: 1rem;">
                        <?php echo $success; ?>
                    </div>
                <?php endif; ?>

                <form method="POST" id="postForm" style="display: flex; flex-direction: column; gap: 1.5rem;">
                    <div>
                        <label style="display: block; margin-bottom: 0.5rem; color: var(--text-muted);">Title</label>
                        <input type="text" name="title" required style="width: 100%; padding: 0.75rem; background: var(--bg-card); border: 1px solid var(--border); color: white; border-radius: 6px; font-size: 1rem;">
                    </div>
                    
                    <div>
                        <label style="display: block; margin-bottom: 0.5rem; color: var(--text-muted);">Content</label>
                        <div id="editor"></div>
                        <input type="hidden" name="content" id="content">
                    </div>
                    
                    <div>
                        <label style="display: block; margin-bottom: 0.5rem; color: var(--text-muted);">Status</label>
                        <select name="status" style="padding: 0.75rem; background: var(--bg-card); border: 1px solid var(--border); color: white; border-radius: 6px; width: 200px;">
                            <option value="published">Published</option>
                            <option value="draft">Draft</option>
                        </select>
                    </div>
                    
                    <button type="submit" class="btn" style="width: fit-content; padding: 0.75rem 2rem; font-size: 1rem;">Create Post</button>
                </form>
            </div>
        </div>
    </main>

    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
        var quill = new Quill('#editor', {
            theme: 'snow',
            modules: {
                toolbar: [
                    [{ 'header': [1, 2, 3, false] }],
                    ['bold', 'italic', 'underline', 'strike'],
                    ['blockquote', 'code-block'],
                    [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                    ['link', 'image'],
                    ['clean']
                ]
            }
        });

        var form = document.getElementById('postForm');
        form.onsubmit = function() {
            var content = document.querySelector('input[name=content]');
            content.value = quill.root.innerHTML;
        };
    </script>
</body>
</html>
