<?php
require_once __DIR__ . '/../../lib/Config.php';
require_once __DIR__ . '/../../lib/DB.php';
require_once __DIR__ . '/../../lib/Auth.php';

Config::load(__DIR__ . '/../../.env');

header('Content-Type: application/json');

if (!Auth::check()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$stats = [
    'total_posts' => DB::fetch("SELECT COUNT(*) as c FROM posts")['c'],
    'published_posts' => DB::fetch("SELECT COUNT(*) as c FROM posts WHERE status = 'published'")['c'],
    'total_views' => DB::fetch("SELECT SUM(views) as c FROM posts")['c'] ?? 0,
    'daily_stats' => DB::fetchAll("SELECT * FROM stats_daily ORDER BY day DESC LIMIT 7")
];

echo json_encode($stats);
