<?php
require_once __DIR__ . '/../lib/Config.php';
require_once __DIR__ . '/../lib/DB.php';

Config::load(__DIR__ . '/../.env');

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 6;
$offset = ($page - 1) * $limit;

$posts = DB::fetchAll("SELECT * FROM posts WHERE status = 'published' ORDER BY published_at DESC LIMIT $limit OFFSET $offset");
$total = DB::fetch("SELECT COUNT(*) as count FROM posts WHERE status = 'published'")['count'];
$totalPages = ceil($total / $limit);

$pageTitle = "Home";
require_once __DIR__ . '/../includes/header.php';
?>

<section class="hero">
    <h1>
        Latest Biographies & Obituaries
    </h1>
</section>

<div class="post-grid">
    <?php foreach ($posts as $post): ?>
    <article class="post-card">
        <div class="post-content">
            <h2><a href="/post.php?slug=<?php echo htmlspecialchars($post['slug']); ?>"><?php echo htmlspecialchars($post['title']); ?></a></h2>
            <div class="post-meta">
                <span><?php echo date('M d, Y', strtotime($post['published_at'])); ?></span>
            </div>
            <div class="post-excerpt">
                <?php 
                    $excerpt = substr(strip_tags($post['content']), 0, 150) . '...';
                    echo $excerpt; 
                ?>
            </div>
            <a href="/post.php?slug=<?php echo htmlspecialchars($post['slug']); ?>" class="read-more">Read Biography &rarr;</a>
        </div>
    </article>
    <?php endforeach; ?>
</div>

<?php if ($totalPages > 1): ?>
<div class="pagination" style="margin-top: 3rem; display: flex; justify-content: center; gap: 1rem;">
    <?php if ($page > 1): ?>
        <a href="?page=<?php echo $page - 1; ?>" class="btn">Previous</a>
    <?php endif; ?>
    
    <?php if ($page < $totalPages): ?>
        <a href="?page=<?php echo $page + 1; ?>" class="btn">Next</a>
    <?php endif; ?>
</div>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
