<?php
require_once __DIR__ . '/../lib/Config.php';
require_once __DIR__ . '/../lib/DB.php';

Config::load(__DIR__ . '/../.env');

$slug = $_GET['slug'] ?? '';

if (!$slug) {
    header("HTTP/1.0 404 Not Found");
    echo "Post not found";
    exit;
}

$post = DB::fetch("SELECT * FROM posts WHERE slug = ? AND status = 'published'", [$slug]);

if (!$post) {
    header("HTTP/1.0 404 Not Found");
    echo "Post not found";
    exit;
}

// Increment views (simple)
DB::query("UPDATE posts SET views = views + 1 WHERE id = ?", [$post['id']]);

// Detailed Tracking
require_once __DIR__ . '/../lib/Analytics.php';
Analytics::track($post['id']);

$pageTitle = $post['title'];
$pageDesc = substr(strip_tags($post['content']), 0, 160);

require_once __DIR__ . '/../includes/header.php';
?>

<article class="single-post">
    <header class="article-header">
        <h1><?php echo htmlspecialchars($post['title']); ?></h1>
        <div class="post-meta">
            Published on <?php echo date('F j, Y', strtotime($post['published_at'])); ?>
            <?php if ($post['source_name']): ?>
                &bull; Source: <?php echo htmlspecialchars($post['source_name']); ?>
            <?php endif; ?>
        </div>
    </header>

    <div class="article-content">
        <?php echo nl2br($post['content']); // Basic formatting, assuming plain text or simple HTML from rewriter ?>
    </div>
    
    <div style="margin-top: 4rem; padding-top: 2rem; border-top: 1px solid var(--border); text-align: center;">
        <a href="/" class="btn">Back to Home</a>
    </div>
</article>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
