<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>System Check</h1>";

// 1. Check PHP Version
echo "<h2>PHP Version</h2>";
echo "Current PHP Version: " . phpversion() . "<br>";

// 2. Check .env file
echo "<h2>Environment File</h2>";
$envPath = __DIR__ . '/../.env';
if (file_exists($envPath)) {
    echo "<span style='color:green'>.env file found.</span><br>";
    
    // Try to parse it manually to check DB creds (masked)
    $lines = file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        list($name, $value) = explode('=', $line, 2);
        if ($name == 'DB_HOST') echo "DB_HOST: $value<br>";
        if ($name == 'DB_NAME') echo "DB_NAME: $value<br>";
        if ($name == 'DB_USER') echo "DB_USER: $value<br>";
        if ($name == 'DB_PASS') echo "DB_PASS: " . (strlen($value) > 0 ? '******' : '(empty)') . "<br>";
    }
} else {
    echo "<span style='color:red'>.env file NOT found at $envPath</span><br>";
}

// 3. Test Database Connection
echo "<h2>Database Connection Test</h2>";

if (file_exists($envPath)) {
    // Simple .env parser for this test
    $env = [];
    $lines = file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        list($name, $value) = explode('=', $line, 2);
        $env[trim($name)] = trim($value);
    }

    try {
        $dsn = "mysql:host=" . $env['DB_HOST'] . ";dbname=" . $env['DB_NAME'] . ";charset=utf8mb4";
        $pdo = new PDO($dsn, $env['DB_USER'], $env['DB_PASS']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        echo "<span style='color:green'>Database connection SUCCESSFUL!</span>";
    } catch (PDOException $e) {
        echo "<span style='color:red'>Database connection FAILED: " . $e->getMessage() . "</span>";
    }
}
?>
