<?php
require_once __DIR__ . '/lib/Config.php';
require_once __DIR__ . '/lib/DB.php';

Config::load(__DIR__ . '/.env');

$username = 'admin';
$password = 'admin123';
$hash = password_hash($password, PASSWORD_DEFAULT);

echo "Resetting password for user: $username\n";
echo "New Hash: $hash\n";

try {
    // Check if user exists
    $user = DB::fetch("SELECT * FROM users WHERE username = ?", [$username]);
    
    if ($user) {
        DB::query("UPDATE users SET password_hash = ? WHERE username = ?", [$hash, $username]);
        echo "Password updated successfully.\n";
    } else {
        DB::insert('users', [
            'username' => $username,
            'password_hash' => $hash,
            'role' => 'admin'
        ]);
        echo "User created successfully.\n";
    }
    
    // Verify immediately
    $user = DB::fetch("SELECT * FROM users WHERE username = ?", [$username]);
    if (password_verify($password, $user['password_hash'])) {
        echo "VERIFICATION SUCCESS: Password matches hash.\n";
    } else {
        echo "VERIFICATION FAILED: Password does not match hash.\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
